/**
 * \file: GstreamerVideoSinkImpl.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto
 *
 * \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_GSTREAMERVIDEOSINKIMPL_H
#define AAUTO_GSTREAMERVIDEOSINKIMPL_H

#include <aauto/util/shared_ptr.h>
#include <aauto/util/WorkQueue.h>
#include <aauto/VideoSink.h>
#include "aauto/AditVideoSink.h"
#include <atomic>
#include <memory.h>
#include <queue>
#include <string>
#include <map>
#include <math.h>
#include "GstreamerVideoPipeline.h"
#include <uspi/ConfigHandle.h>
#include "GstreamerVideoSinkRecord.h"

#define VIDEO_OUT_TIMEOUT       500000000LL

// forward declarations
struct _GstElement;
typedef struct _GstElement GstElement;
typedef unsigned long int pthread_t;


namespace adit { namespace aauto {

struct VideoResolution {
    int width;
    int height;
};

struct PlayerResolution {
    int tlx;
    int tly;
    int brx;
    int bry;
    int w;
    int h;
    int density;
    int pixelAspectRatio;
    int fps;
    int additionalDepth;
};

struct VideoCodecRes {
    int     width;
    int     height;
    int     density;
    float   pixelAspectRatio;
    int     additionalDepth;
    int     fps;
};


class VideoSinkConfig : public uspi::ConfigHandle
{
public:
VideoSinkConfig()
{
    mCodec = "";
    mMaxUnackedFrames = 0;;
    mWidth = 0;
    mHeight = 0;
    mDensity = 0;
    mFps = 0;
    mVideoPipeline = "";
    mAdditionalDepth = 0;
    mPixelAspectRatio = 0;  // reported to MD to receive video corrected for non-square pixels
    mVideoRecord = 0;
    mVideoFileRecord = "";
    mDisablePrio = 0;
    mThreadPrio = 0;
}

bool ResultConfig()
{
    bool isValid = true;
    mCodec               = getString("video-codec", &isValid, MatchStrings(1, "MEDIA_CODEC_VIDEO_H264_BP"), "MEDIA_CODEC_VIDEO_H264_BP");
    mMaxUnackedFrames    = getInt("video-max-unacked-frames", &isValid, Range(1, INT_MAX), 4);
    mWidth               = getInt("video-width", &isValid, Range(-1, INT_MAX), 800);
    mHeight              = getInt("video-height", &isValid, Range(-1, INT_MAX), 480);
    mDensity             = getInt("video-density", &isValid, Range(-1, INT_MAX), 160);
    mFps                 = getInt("video-fps", &isValid, Match(2, 30, 60), 30);
    mPixelAspectRatio    = getFloat("video-pixelAspectRatio", &isValid, Range(0, INT_MAX), 1.0);
    mAdditionalDepth     = getInt("video-additional-depth", &isValid, Range(0, 10), 0);
    mVideoPipeline       = getString("gstreamer-video-pipeline", &isValid, Range(-1, INT_MAX));
    mVideoRecord         = getIntMultiKey("gstreamer-videosink-record", "enable", &isValid, Range(-1, 1), 0);
    mVideoFileRecord     = getStringMultiKey("gstreamer-videosink-record", "filename", &isValid, Range(-1, INT_MAX), "");
    mDisablePrio         = getInt("disable-real-time-priority-video", &isValid, Range(0, 1), 0);
    mThreadPrio          = getInt("video-threads-real-time-priority", &isValid, Range(-1, INT_MAX), 42);

    VideoCodecRes res;

    for (unsigned int i = 0; i < VideoCodecResolutionType_MAX; i++)
    {
        memset(&res, 0, sizeof(VideoCodecRes));
        res.width = getIntMultiKey(mStrVideoCodecResolutions[i].c_str(), "width", &isValid, Range(-1, 1920), 0);
        if (res.width > 0)
        {
            res.height             = getIntMultiKey(mStrVideoCodecResolutions[i].c_str(), "height", &isValid, Range(-1, 1080), 0);
            res.density            = getIntMultiKey(mStrVideoCodecResolutions[i].c_str(), "density", &isValid, Range(-1, INT_MAX), 0);
            res.pixelAspectRatio   = getFloatMultiKey(mStrVideoCodecResolutions[i].c_str(), "pixelaspectratio", &isValid, Range(0.0, INT_MAX), 0.0);
            res.additionalDepth    = getIntMultiKey(mStrVideoCodecResolutions[i].c_str(), "additional-depth", &isValid, Range(0, 10), 0);
            res.fps                = getIntMultiKey(mStrVideoCodecResolutions[i].c_str(), "fps", &isValid, Range(-1, 60), 0);
            mCodecRes.push_back(res);
        }
    }

    return isValid;
}

    string  mCodec;
    int     mMaxUnackedFrames;
    int     mWidth;
    int     mHeight;
    int     mDensity;
    int     mFps;
    string  mVideoPipeline;
    int     mAdditionalDepth;
    float   mPixelAspectRatio;
    int     mVideoRecord;
    string  mVideoFileRecord;
    bool    mDisablePrio;
    int     mThreadPrio;

    deque<VideoCodecRes> mCodecRes;
    string mStrVideoCodecResolutions[VideoCodecResolutionType_MAX] = {{"video-codec-resolution-1920x1080"}, {"video-codec-resolution-1280x720"}, {"video-codec-resolution-800x480"}};
}; // class VideoSinkConfig : public ConfigHandle

class GstreamerVideoSinkImpl : public IVideoSinkCallbacks
{
public:


    enum Framerate
    {
        FRAMERATE_30 = 30,
        FRAMERATE_60 = 60,

        FRAMERATE_LAST = 0xffffffff
    };

    GstreamerVideoSinkImpl(VideoSink* inSink, void* inSessionContext);
    ~GstreamerVideoSinkImpl();
    bool init();
    void shutdown();
    void setConfigItem(string inKey, string inValue);
    void registerCallbacks(IAditVideoSinkCallbacks* inCallbacks);

protected:
    // IVideoSinkCallbacks
    void dataAvailableCallback(int32_t inSessionId, uint64_t inTimestamp,
            uint8_t* inData, size_t inLen);
    void dataAvailableCallback(int32_t inSessionId, uint64_t inTimestamp,
            const shared_ptr<IoBuffer>& inFrame, uint8_t* inData, size_t inLen);
    int codecConfigCallback(uint8_t* inData, size_t inLen);
    int setupCallback(int inMediaCodecType);
    void playbackStartCallback(int32_t inSessionId);
    void playbackStopCallback(int32_t inSessionId);
    void sourceVideoConfigCallback(int inIndex);
    void videoFocusCallback(int inFocus, int inReason);

private:
    class FrameItem: public WorkItem
    {
    public:
        FrameItem(GstreamerVideoSinkImpl& inSink, GstreamerVideoPipeline& inVideoPipeline, int32_t inSessionId, uint64_t inTimestamp,
                const shared_ptr<IoBuffer>& inData, uint8_t* inDataPtr, size_t inLen) :
                    sink(inSink), Video(inVideoPipeline), mSessionId(inSessionId), mTimestamp(inTimestamp), mData(inData), mDataPtr(inDataPtr), mLen(inLen){}

    protected:
        // WorkItem implementation
        void run();
    private:
        void SetThreadParam(const char* threadName);

        GstreamerVideoSinkImpl& sink;
        GstreamerVideoPipeline& Video;
        int32_t mSessionId;
        uint64_t mTimestamp;
        shared_ptr<IoBuffer> mData;
        uint8_t* mDataPtr;
        size_t mLen;
    };

    VideoSink* videoSink;
    shared_ptr<WorkQueue> workQueue;

    bool mIsSetThreadParam;

    void addSupportedConfigurations(int32_t codec, int32_t inWidth, int32_t inHeigth, int32_t inDensity, float inPixelAspectRatio);
    void addSupportedConfigurations(int32_t codec);
    void calculateClipped(int x, int y, int cx, int cy, PlayerResolution* res);
    bool getCurrentResolution(PlayerResolution* res);
    bool configErrorHandle();

    bool videoRunning;
    bool mShutdown;

    deque<PlayerResolution> mResolutions;
    int mSelectedResolution = -1;
    VideoSinkConfig mConfig;
    IAditVideoSinkCallbacks* mcallbacks;

    //Gstreamer
    GstreamerVideoPipeline* VideoPipeline;
    int32_t gwidth, gheight;
    GstreamerVideoSinkRecord VideoFrameRecord;
    bool VideoSinkRecordRunning;
    void* sessionContext;

};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_GSTREAMERVIDEOSINKIMPL_H */
